* descriptive.sas;
options pageno=1 linesize=80;
goptions reset=all;
title 'Descriptive statistics for the elytra data';
data elytra;
	input sex $ length;
	datalines;
M	4.9
F	5.2
M	4.9
F	4.2
F	5.7
M	4.6
M	3.8
F	5.4
F	4.0
F	4.5
M	4.9
F	5.2
M	4.9
F	4.2
F	5.7
M	4.6
M	3.8
F	5.4
F	4.0
F	4.5
F	5.2
F	4.9
M	5.0
M	4.4
M	5.0
M	5.0
M	4.9
F	4.5
F	4.5
M	5.1
F	5.5
M	4.8
F	4.9
M	4.8
M	4.5
M	4.5
M	4.4
M	5.2
M	4.1
F	5.0
M	4.4
F	4.9
M	4.7
M	4.4
F	4.8
F	4.5
M	4.0
M	3.4
F	5.5
M	4.7
M	4.8
F	4.8
F	3.7
M	5.3
M	4.6
F	4.8
M	4.5
M	5.0
M	4.4
F	4.6
M	4.4
M	4.9
F	5.3
F	5.0
F	4.7
F	5.2
M	5.0
M	5.0
M	4.8
M	5.8
F	5.7
F	5.2
M	4.9
F	5.1
F	5.3
F	5.3
F	5.9
F	5.3
M	4.5
F	5.2
M	5.1
F	4.6
M	4.8
M	3.5
F	4.6
F	5.3
M	5.2
F	4.8
M	5.1
M	5.2
M	4.9
M	5.3
M	5.2
F	4.9
F	5.6
M	5.0
M	5.0
F	5.1
M	5.1
F	5.5
M	5.1
F	4.8
F	4.9
F	5.0
M	4.9
M	5.0
F	5.0
M	4.9
M	4.8
F	5.2
F	4.8
M	4.7
F	5.1
M	4.5
M	5.0
F	5.4
F	4.6
M	4.0
M	4.2
F	5.2
F	4.6
M	5.0
M	3.7
M	4.6
M	4.0
M	5.1
F	4.4
M	4.8
M	4.6
F	3.7
;
run;
* Print data set;
proc print data=elytra;
run;
* Descriptive statistics and histograms;
proc univariate plots data=elytra;
	* Separate analyses for each sex;
	class sex; 
	var length;
	histogram length / vscale=count wbarline=3 waxis=3 height=4;
run;
quit;
